﻿$(document).ready(function () {
    $('#FTPSecurity').on("change", function () {
        if ($('#FTPSecurity').val() == "SFTP")
            $("#sftpPrivateKey").show();
        else
            $("#sftpPrivateKey").hide();
    });

    $('#FTPSecurity').trigger("change");

    $('#PublishToFTP').on("change", function () {
        if ($('#PublishToFTP').is(":checked")) {
            $("#ftpSettings").show();
            $(this).closest(".checkbox-parent-section").addClass("checkbox-option-selected");
        }
        else {
            $("#ftpSettings").hide();
            $(this).closest(".checkbox-parent-section").removeClass("checkbox-option-selected");
        }
    });

    $('#PublishToFTP').trigger("change");

    $(".h-testConnection").on("click", function () {
        var panel = $(this).closest("#ftpSettings");
        var editor = $(this).closest(".v-exportResponsesWizard");
        
        a4.callServerMethod(a4.getAction("TestFTPConnection", "Analyze", "Survey"), { id: $("#TaskId").val(), isImport: false, address: $("#FTPAddress", panel).val(), username: $("#FTPUsername", panel).val(), password: $("#FTPPassword", panel).val(), folder: $("#FTPFolder", panel).val(), security: $("#FTPSecurity", panel).val(), openSSHPrivateKey: $("#OpenSSHPrivateKey", panel).val() },
            function (result) {
                if (result.Success)
                    a4.showSuccessMessage(result.Message, 2000);
                else
                    a4.showErrorMessage(result.Message);
            });
    });

    if ($("input[type='radio'].h-attributeSubset").is(":checked")) {
        $("#attributeSelectorContainer").show();
        loadAttributeList();
    }

    $("input[type='radio'][name='IsAttributeSubset']").on("change", function () {
        var parent = $(this).closest(".field");
        var subset = $(".h-attributeSubset", parent).is(":checked");
        $(".h-selectAttributes", parent).toggle(subset);

        $("#attributeSelectorContainer").toggle(subset);

        if (subset) {
            loadAttributeList();
        }
    });

    $(".h-selectAttributes").on("click", function () {
        modalDialog.showWindow(a4.getAction("AddAttributes", "Panelists", "Panel", { includeSystemAttributes: true, enableLimitedSelection: false }), 620, 950, {
            beforeClose: function () {
                var attributeSelector = $('.fancybox-iframe').contents();
                var confirmed = attributeSelector.find(".v-confirmed").val();
                if (confirmed) {
                    var attributeIds = $('.v-selectedAttributes', attributeSelector).val();

                    a4.callServerMethod(a4.getAction("GetPanelistsPageConfigurationNamesById", "Panelists", "Panel"), { config: attributeIds, includeSystemAttributes: true }).then(function (result) {
                        if (result) {
                            panelAttributeEditor.selectAttributes(_.pluck(JSON.parse(result.configResult), "Name"));
                        }
                    });
                }
            }
        });
    });
});

function loadAttributeList() {
    var cnt = $("#attributeSelectorContainer");

    if (!cnt.hasClass("loaded")) {
        a4.callServerMethod(a4.getAction("InlineAttributeEditor", "Panelists", "Panel"), {},
            function (result) {
                $("#attributeSelectorContainer").html(result);
                panelAttributeEditor.initPanelAttributeEditor();
                cnt.addClass("loaded");
            });
    }
}

function SetAttributesSelection(data) {
    $("#JSONAttributes", $(".v-createExportPanelists")).val(data);
}